/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.events;

import java.util.UUID;
import org.bukkit.event.HandlerList;
import ru.tehkode.permissions.PermissionEntity;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.events.PermissionEvent;

public class PermissionEntityEvent
extends PermissionEvent {
    private static final HandlerList handlers = new HandlerList();
    protected transient PermissionEntity entity;
    protected Action action;
    protected PermissionEntity.Type type;
    protected String entityIdentifier;

    public PermissionEntityEvent(UUID sourceUUID, PermissionEntity entity, Action action) {
        super(sourceUUID);
        this.entity = entity;
        this.entityIdentifier = entity.getIdentifier();
        this.type = entity.getType();
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public PermissionEntity getEntity() {
        if (this.entity == null) {
            switch (this.type) {
                case GROUP: {
                    this.entity = PermissionsEx.getPermissionManager().getGroup(this.entityIdentifier);
                    break;
                }
                case USER: {
                    this.entity = PermissionsEx.getPermissionManager().getUser(this.entityIdentifier);
                }
            }
        }
        return this.entity;
    }

    public String getEntityIdentifier() {
        return this.entityIdentifier;
    }

    public PermissionEntity.Type getType() {
        return this.type;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum Action {
        PERMISSIONS_CHANGED,
        OPTIONS_CHANGED,
        INHERITANCE_CHANGED,
        INFO_CHANGED,
        TIMEDPERMISSION_EXPIRED,
        RANK_CHANGED,
        DEFAULTGROUP_CHANGED,
        WEIGHT_CHANGED,
        SAVED,
        REMOVED;

    }
}

