/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.json.simple.JSONObject;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.backends.PermissionBackend;
import ru.tehkode.permissions.exceptions.PermissionBackendException;

public class MultiBackend
extends PermissionBackend {
    private final List<PermissionBackend> backends = new ArrayList<PermissionBackend>();
    private final Map<String, PermissionBackend> fallbackBackends = new HashMap<String, PermissionBackend>();

    public MultiBackend(PermissionManager manager, ConfigurationSection backendConfig) throws PermissionBackendException {
        super(manager, backendConfig);
        HashMap<String, PermissionBackend> backendMap = new HashMap<String, PermissionBackend>();
        List backendNames = backendConfig.getStringList("backends");
        if (backendNames.isEmpty()) {
            backendConfig.set("backends", new ArrayList());
            throw new PermissionBackendException("No backends configured for multi backend! Please configure this!");
        }
        for (String name : backendConfig.getStringList("backends")) {
            PermissionBackend backend = manager.createBackend(name);
            this.backends.add(backend);
            backendMap.put(name, backend);
        }
        ConfigurationSection fallbackSection = backendConfig.getConfigurationSection("fallback");
        if (fallbackSection != null) {
            for (Map.Entry ent : fallbackSection.getValues(false).entrySet()) {
                PermissionBackend backend = (PermissionBackend)backendMap.get(ent.getValue());
                if (backend == null) {
                    throw new PermissionBackendException("Fallback backend type " + ent.getValue() + " is not listed in the backends section of MultiBackend (and must be for this contraption to work)");
                }
                this.fallbackBackends.put((String)ent.getKey(), backend);
            }
        }
    }

    @Override
    public int getSchemaVersion() {
        return -1;
    }

    @Override
    protected void setSchemaVersion(int version) {
    }

    public PermissionBackend getFallbackBackend(String type) {
        if (this.fallbackBackends.containsKey(type)) {
            return this.fallbackBackends.get(type);
        }
        return this.backends.get(0);
    }

    @Override
    public void reload() throws PermissionBackendException {
        for (PermissionBackend backend : this.backends) {
            backend.reload();
        }
    }

    @Override
    public PermissionsUserData getUserData(String userName) {
        for (PermissionBackend backend : this.backends) {
            if (!backend.hasUser(userName)) continue;
            return backend.getUserData(userName);
        }
        return this.getFallbackBackend("user").getUserData(userName);
    }

    @Override
    public PermissionsGroupData getGroupData(String groupName) {
        for (PermissionBackend backend : this.backends) {
            if (!backend.hasGroup(groupName)) continue;
            return backend.getGroupData(groupName);
        }
        return this.getFallbackBackend("group").getGroupData(groupName);
    }

    @Override
    public boolean hasUser(String userName) {
        for (PermissionBackend backend : this.backends) {
            if (!backend.hasUser(userName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGroup(String group) {
        for (PermissionBackend backend : this.backends) {
            if (!backend.hasGroup(group)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getUserIdentifiers() {
        HashSet<String> ret = new HashSet<String>();
        for (PermissionBackend backend : this.backends) {
            ret.addAll(backend.getUserIdentifiers());
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Collection<String> getUserNames() {
        HashSet<String> ret = new HashSet<String>();
        for (PermissionBackend backend : this.backends) {
            ret.addAll(backend.getUserNames());
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Collection<String> getGroupNames() {
        HashSet<String> ret = new HashSet<String>();
        for (PermissionBackend backend : this.backends) {
            ret.addAll(backend.getGroupNames());
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public List<String> getWorldInheritance(String world) {
        for (PermissionBackend backend : this.backends) {
            List<String> potentialRet = backend.getWorldInheritance(world);
            if (potentialRet == null || potentialRet.size() <= 0) continue;
            return potentialRet;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, List<String>> getAllWorldInheritance() {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (int i = this.backends.size(); i >= 0; --i) {
            ret.putAll(this.backends.get(i).getAllWorldInheritance());
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public void setWorldInheritance(String world, List<String> inheritance) {
        this.getFallbackBackend("world").setWorldInheritance(world, inheritance);
    }

    @Override
    public void writeContents(Writer writer) throws IOException {
        JSONObject obj = new JSONObject();
        for (PermissionBackend backend : this.backends) {
            StringWriter stringW = new StringWriter();
            backend.writeContents(stringW);
            obj.put((Object)backend.toString(), (Object)stringW.toString());
        }
        obj.writeJSONString(writer);
    }
}

