/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import ru.tehkode.permissions.PermissionEntity;
import ru.tehkode.permissions.PermissionGroup;

public abstract class HierarchyTraverser<Return> {
    private final PermissionEntity start;
    private final String world;
    private final boolean traverseInheritance;

    public HierarchyTraverser(PermissionEntity entity, String world) {
        this(entity, world, true);
    }

    public HierarchyTraverser(PermissionEntity entity, String world, boolean traverseInheritance) {
        this.start = entity;
        this.world = world;
        this.traverseInheritance = traverseInheritance;
    }

    public Return traverse() {
        LinkedList<PermissionEntity> entities = new LinkedList<PermissionEntity>();
        HashSet<PermissionEntity> visited = new HashSet<PermissionEntity>();
        entities.add(this.start);
        Return ret = null;
        while (!entities.isEmpty()) {
            PermissionEntity current = (PermissionEntity)entities.removeFirst();
            if (visited.contains(current)) {
                if (!current.isDebug()) continue;
                current.manager.getLogger().warning("Potential circular inheritance detected involving group " + current.getIdentifier() + " (when performing traversal for entity " + this.start + ")");
                continue;
            }
            visited.add(current);
            if (this.world != null && ((ret = (Return)this.fetchLocal(current, this.world)) != null || (ret = (Return)this.traverseWorldInheritance(current)) != null) || (ret = (Return)this.fetchLocal(current, null)) != null) break;
            if (!this.traverseInheritance) continue;
            List<PermissionGroup> parents = current.getParents(this.world);
            for (int i = parents.size() - 1; i >= 0; --i) {
                entities.addFirst(parents.get(i));
            }
        }
        return ret;
    }

    private Return traverseWorldInheritance(PermissionEntity entity) {
        List<String> worldInheritance = entity.manager.getWorldInheritance(this.world);
        if (worldInheritance.size() > 0) {
            LinkedList<String> worlds = new LinkedList<String>(worldInheritance);
            HashSet<String> visitedWorlds = new HashSet<String>();
            Return ret = null;
            while (!worlds.isEmpty()) {
                String current = (String)worlds.removeFirst();
                if (visitedWorlds.contains(current)) {
                    if (!entity.isDebug()) continue;
                    entity.manager.getLogger().warning("Potential circular inheritance detected with world inheritance for world " + current);
                    continue;
                }
                visitedWorlds.add(current);
                ret = this.fetchLocal(entity, current);
                if (ret != null) break;
                List<String> nextLevel = entity.manager.getWorldInheritance(current);
                for (int i = nextLevel.size() - 1; i >= 0; --i) {
                    worlds.add(nextLevel.get(i));
                }
            }
            return ret;
        }
        return null;
    }

    protected abstract Return fetchLocal(PermissionEntity var1, String var2);
}

